// RwExp.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "RwExp.h"

#include "max.h"
#include "DffExp.h"
#include "BspExp.h"
#include "SplExp.h"
#include "RwParticle.h"

extern ClassDesc2* GetRwParticleDesc();

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static HINSTANCE                hGInstance;
static HWND                     hGWndTextEdit;
static int                      GcontrolsInit = FALSE;
static DFFClassDesc             GDFFDesc;
static BSPClassDesc             GBSPDesc;
static SPLClassDesc             GSPLDesc;
static RwParticleClassDesc      GParticleClassDesc;
HWND                            hGMaxHWnd;

/////////////////////////////////////////////////////////////////////////////
// CRwExpApp

BEGIN_MESSAGE_MAP(CRwExpApp, CWinApp)
    //{{AFX_MSG_MAP(CRwExpApp)
        // NOTE - the ClassWizard will add and remove mapping macros here.
        //    DO NOT EDIT what you see in these blocks of generated code!
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRwExpApp construction

CRwExpApp::CRwExpApp()
{
    // TODO: add construction code here,
    // Place all significant initialization in InitInstance
}

BOOL CRwExpApp::InitInstance() 
{
    // TODO: Add your specialized code here and/or call the base class
    if (!GcontrolsInit)
    {
        GcontrolsInit = TRUE;
        
        /* Jaguar controls (i.e. MAX's custom controls) */
        InitCustomControls(m_hInstance);

        /* Initialize Chicago controls (i.e. WIN95 controls) */
        InitCommonControls();
    }

    return (CWinApp::InitInstance());
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CRwExpApp object

CRwExpApp theApp;

__declspec( dllexport ) int
LibNumberClasses()
{
    return (4);
}

__declspec( dllexport ) ClassDesc *
LibClassDesc(int i)
{
    ClassDesc *result = NULL;
    
    switch (i)
    {
        case 0:
        {
            result =  (&GDFFDesc);
            break;
        }
        case 1:
        {
            result =  (&GBSPDesc);
            break;
        }        
        case 2:
        {
            result =  (&GSPLDesc);
            break;
        }
        case 3:
        {
            result = GetRwParticleDesc();
            break;
        }
    }

    return result;
}

__declspec( dllexport ) const TCHAR *
LibDescription()
{
    return (_T("RW3.1 Library File Export Plug-In"));
}

__declspec( dllexport ) ULONG 
LibVersion()
{
    return (VERSION_3DSMAX);
}
